@extends('layouts.default')

@section('conteudo')
<h5>Gerenciamento de Cardápios
    <a href="{{url('cardapio/'.$action)}}" class="material-icons float-right" style="font-size: 1.3em; color: #333;">
        keyboard_backspace
    </a>
</h5>
<hr>

<form method="post" action="{{ url('cardapio/salvar-tipo-cardapio') }}" enctype="multipart/form-data">
    {{ @csrf_field() }}

    <input type="hidden" name="id" id="id" value="">
    <input type="hidden" name="action" value="{{ $action }}">

    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <div><label>Nome do Cardápio</label></div>
                <input name="tipo" id="tipo" value="{{ old('tipo') ?? '' }}" class="form-control">
            </div>
        </div>

        <div class="col-md-12">
            <div class="form-group">
                <div><label>Foto</label></div>
                <input type="file" name="foto[]" id="foto" multiple accept="image/*" class="form-control">
            </div>
        </div>
    </div>

    <div class="row">
        <div class="form-group">
            <button type="submit" class="btn btn-parque ml-3 btn">Salvar</button>
            <button type="reset" onclick="limparForm()" class="btn btn-secondary">Limpar</button>
        </div>
    </div>

    @if (session('sucesso'))
    <div class="alert alert-success">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        {!! session('sucesso') !!}
    </div>
    @endif
    @if (session('error'))
    <div class="alert alert-danger">
        <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        {!! session('error') !!}
    </div>
    @endif


    @if($tiposCardapios->count() > 0)
    <table class="table table-hover" width="100%">
        <tr bgColor="#eee">
            <th colspan="2" class="bg-success text-white">PDV</th>
            <th class="bg-success text-white" style="text-align: center;">Status</th>
            <th class="bg-success text-white" style="text-align: center;">Ação</th>
        </tr>
        @foreach($tiposCardapios as $item)
        @if($item->status != 2)
        <tr>
            <td width="5%" class="p-0 pt-1 pb-1">
                <img width="50px" src="{{ url('cardapio/tipo-cardapio/thumb/'.$item->id) }}" onerror="this.src='<?= url('images/foto-error.png') ?>'" alt="">
            </td>
            <td class="p-0 pt-1 pl-1">
                <b>{{ $item->nome }}</b>
                <div>
                    @if($item->status == 1)
                    <label class="badge badge-success">Ativo</label>
                    @elseif($item->status == 0)
                    <label class="badge badge-danger">Inativo</label>
                    @endif
                </div>
            </td>
            <td width="1%">
                <input type="checkbox" name="status" id="status" onclick="changeStatus(this)" value="{{$item->id}}" {{ $item->status==1 ? 'checked' : '' }}>
            </td>
            <td width="1%" align="right">
                <div class="btn-group" role="group" aria-label="...">
                    <div class="btn btn-primary btn-sm m-0" onclick="editar({{$item->id}}, '{{ $item->nome }}')"><i class="material-icons icone">edit</i></div>
                    <div class="btn btn-danger btn-sm m-0" onclick="deleta({{$item->id}})"><i class="material-icons icone">delete</i></div>
                </div>
            </td>
        </tr>
        @endif
        @endforeach
    </table>
    @else
    <div class="alert alert-info">Nenhum registro encontrado</div>
    @endif

</form>
@endsection

@section('scripts')
<script>
    function editar(id, nome) {
        document.getElementById('id').value = id;
        document.getElementById('tipo').value = nome;

        //document.body.scrollTop = 0; // For Safari
        //document.documentElement.scrollTop = 0; // For Chrome, Firefox, IE and Opera
        $('html, body').animate({
            scrollTop: 0
        }, '300');
    }

    function changeStatus(e) {
        var url = (e.checked === true) ? 'cardapio/ativar-cardapio' : 'cardapio/inativar-cardapio';

        $.ajax({
            type: 'POST',
            url: BASE_URL + url,
            data: {
                _token: document.getElementsByName('_token')[0].value,
                id: e.value
            },
            success: (response) => {
                window.location.reload();
            }
        });
    }

    function deleta(id) {
        if (confirm('Deseja realmente remover este Cardápio (PDV) ?')) {
            window.location = BASE_URL + 'cardapio/delete/' + id;
        }
    }

    function limparForm() {
        document.getElementById('id').value = '';
        document.getElementById('tipo').value = '';
        document.getElementById('foto').value = '';
    }
</script>
@endsection